<?php
include 'setings.php';

function deleteTxtFiles($folder_path) {
    $files = glob($folder_path . "*.txt");
    foreach ($files as $file) {
        if (is_file($file)) {
            unlink($file);
        }
    }
}

$currentDateTime = date('Y-m-d H:i:s');

// Check if user clicked a title
if (isset($_GET['id'])) {
    $random_id = intval($_GET['id']);

    // Fetch category & slug of clicked id
    $sql = "SELECT id, category, slug FROM tags WHERE id = $random_id AND sts = 0 LIMIT 1";
    $result = $con->query($sql);

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $category  = $row['category'];
        $slug      = $row['slug'];

        // Update records in all 3 tables
        $sql1 = "UPDATE tags SET pubdate = '$currentDateTime', moddate = '$currentDateTime', sts = 1 WHERE id = $random_id";
        $con->query($sql1);

        $sql2 = "UPDATE bikesTags SET pubdate = '$currentDateTime', moddate = '$currentDateTime', sts = 1 WHERE id = $random_id";
        $con->query($sql2);

        $sql3 = "UPDATE carsTags SET pubdate = '$currentDateTime', moddate = '$currentDateTime', sts = 1 WHERE id = $random_id";
        $con->query($sql3);

        // Fetch post data based on category
        if ($category == 'Bikes') {    
            $data  = file_get_contents($siteurl . "getBikePost.php?bioid=" . $random_id);
            $datas = json_decode($data, true);
        } else {
            $data  = file_get_contents($siteurl . "getCarPost.php?bioid=" . $random_id);
            $datas = json_decode($data, true);   
        }

        $checkimage = ltrim($datas['featcher'], '/');

        if (!file_exists($checkimage)) {
            $sql1 = "UPDATE tags SET sts = 2 WHERE id = $random_id";
            $con->query($sql1);

            unlink($cacheFolder . $random_id . ".txt");    
            echo "Post Failed to Publish";    
        } else {    
            // Clear cache
            deleteTxtFiles($homepagecached);
            deleteTxtFiles($other_cached);

            $title = $datas['title']; // fetched from getBikePost.php / getCarPost.php
            echo "Post Published | <a target='_blank' href='$siteurl$slug/'>$title</a>";
        }    
    } else {
        echo "Record not found or already published.";
    }
} else {
    // Display random clickable titles (use slug as placeholder if needed)
    $sql = "SELECT id, slug, category FROM tags WHERE sts = 0 ORDER BY RAND() LIMIT 5";
    $result = $con->query($sql);

    if ($result->num_rows > 0) {
        echo "<h3>Click a title to publish the post:</h3><ul>";
        while ($row = $result->fetch_assoc()) {
            $id = $row['id'];
            $slug = $row['slug'];
            $category = $row['category'];

            // You can optionally fetch the real title here from getBikePost.php / getCarPost.php for display
            if ($category == 'Bikes') {
                $data = file_get_contents($siteurl . "getBikePost.php?bioid=" . $id);
                $datas = json_decode($data, true);
            } else {
                $data = file_get_contents($siteurl . "getCarPost.php?bioid=" . $id);
                $datas = json_decode($data, true);
            }

            $title = $datas['title'];
            echo "<li><a href='?id=$id'>$title</a></li>";
        }
        echo "</ul>";
    } else {
        echo "No unpublished records found.";
    }
}

// Close connection
$con->close();
?>