<?php
ini_set('error_reporting', E_ALL);
ini_set('display_errors', true);
error_reporting(E_ALL);
date_default_timezone_set('Asia/Kolkata');

/**
 * Helper: Remove domain extension (e.g., .com)
 */
function removeExtensionFromDomain($domain) {
    $parsedDomain = parse_url($domain, PHP_URL_HOST) ?: $domain;
    $domainParts = explode('.', $parsedDomain);
    array_pop($domainParts);
    return implode('.', $domainParts);
}

// Domain & site variables
$domain   = $_SERVER['HTTP_HOST'];
$siteurl  = "https://$domain/";
$logotext = ucwords(removeExtensionFromDomain($domain));
$email    = "support@$domain";
$sitename = ucwords($logotext);
$logourl  = $siteurl . "includes/images/logo.png";

// OpenGraph URL setup
if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') {
    $ogurl = "https://";
} else {
    $ogurl = "http://";
}
$ogurl .= $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];

// Cache folders
$homepagecached = "homepagecached/";
$other_cached   = "other_cached/";
$cacheFolder    = "cached/";

// Include DB credentials
include 'db.php';

// Database connection (extra safety)
try {
    $con = mysqli_connect($hostname, $username, $password, $dbname);
    if (!$con) {
        throw new Exception("Database connection failed.");
    }
    // ✅ Ensure utf8mb4 for full Unicode
    mysqli_set_charset($con, "utf8mb4");

} catch (Exception $e) {
    error_log($e->getMessage());
    header('Location: ' . $siteurl . 'newSetup.php?password=1704142');
    exit();
}

// Site-wide settings
$headergrouplinks = true;
$footergrouplinks = true;
$telegramLink = "#";
$whatsappLink = "#";
$autoscrall = false;
$autoredirection = false;

// Ad placeholders
$autoads_code = '<meta name="google-site-verification" content="1234567890" />';
$responsive_code = '';
$headerads = '';
$footerads = '';
$article1ads = '';
$article2ads = '';
$article3ads = '';
$article4ads = '';
$article5ads = '';
$sidebarads = '';
$stickeyads = '';

?>
